/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.Util;
import com.wgshim.doclets.ClassSubWriter;
import com.wgshim.doclets.ConfigurationStandard;
import com.wgshim.doclets.ConstructorSubWriter;
import com.wgshim.doclets.FieldSubWriter;
import com.wgshim.doclets.HtmlStandardWriter;
import com.wgshim.doclets.MethodSubWriter;
import com.wgshim.doclets.Standard;
import com.wgshim.doclets.SubWriterHolderWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;

public class ClassWriter
extends SubWriterHolderWriter {
    protected ClassDoc classdoc;
    protected ClassTree classtree;
    protected ClassDoc prev;
    protected ClassDoc next;
    protected boolean nopackage;
    protected MethodSubWriter methodSubWriter;
    protected ConstructorSubWriter constrSubWriter;
    protected FieldSubWriter fieldSubWriter;
    protected ClassSubWriter innerSubWriter;

    public ClassWriter(String path, String filename, ClassDoc classdoc, ClassDoc prev, ClassDoc next, ClassTree classtree, boolean nopackage) throws IOException, DocletAbortException {
        super(path, filename, DirectoryManager.getRelativePath((String)classdoc.containingPackage().name()));
        this.classdoc = classdoc;
        HtmlStandardWriter.currentcd = classdoc;
        this.classtree = classtree;
        this.prev = prev;
        this.next = next;
        this.nopackage = nopackage;
        this.methodSubWriter = new MethodSubWriter(this, classdoc);
        this.constrSubWriter = new ConstructorSubWriter(this, classdoc);
        this.fieldSubWriter = new FieldSubWriter(this, classdoc);
        this.innerSubWriter = new ClassSubWriter(this, classdoc);
    }

    public static void generate(ClassDoc classdoc, ClassDoc prev, ClassDoc next, ClassTree classtree, boolean nopackage) throws DocletAbortException {
        String path = DirectoryManager.getDirectoryPath((PackageDoc)classdoc.containingPackage());
        String filename = String.valueOf(classdoc.name()) + ".html";
        try {
            ClassWriter clsgen = new ClassWriter(path, filename, classdoc, prev, next, classtree, nopackage);
            clsgen.generateClassFile();
            ((PrintWriter)((Object)clsgen)).close();
        }
        catch (IOException exc) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkClass() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Class");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkClassUse() {
        this.navCellStart();
        this.printHyperLink("class-use/" + this.filename, "", this.getText("doclet.navClassUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Class");
        } else {
            this.printClassLink(this.prev, this.getText("doclet.Prev_Class"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Class");
        } else {
            this.printClassLink(this.next, this.getText("doclet.Next_Class"), true);
        }
    }

    public void generateClassFile() {
        String cltype = String.valueOf(this.getText(this.classdoc.isInterface() ? "doclet.Interface" : "doclet.Class")) + " ";
        PackageDoc pkg = this.classdoc.containingPackage();
        String pkgname = pkg != null ? pkg.name() : "";
        String clname = this.classdoc.name();
        String label = String.valueOf(cltype) + ' ' + clname;
        this.printHeader(this.getText("doclet.Window_ClassFile_label", Standard.configuration().windowtitle, label));
        this.navLinks(true);
        this.hr();
        ((PrintWriter)((Object)this)).println("<!-- ======== START OF CLASS DATA ======== -->");
        this.h2();
        if (pkgname.length() > 0) {
            this.font("-1");
            ((PrintWriter)((Object)this)).print(pkgname);
            this.fontEnd();
            this.br();
        }
        ((PrintWriter)((Object)this)).print(label);
        this.h2End();
        if (this.classdoc.isClass()) {
            this.pre();
            this.printTreeForClass(this.classdoc);
            this.preEnd();
        }
        this.printSuperImplementedInterfacesInfo();
        this.printSubClassInterfaceInfo();
        if (this.classdoc.isInterface()) {
            this.printImplementingClasses();
        }
        this.printEnclosingClassInfo();
        this.hr();
        this.printDeprecated();
        this.printClassDescription();
        this.p();
        if (this.classdoc.inlineTags().length > 0) {
            this.printInlineComment((Doc)this.classdoc);
            this.p();
        }
        this.generateTagInfo((Doc)this.classdoc);
        this.hr();
        this.p();
        this.printAllMembers();
        ((PrintWriter)((Object)this)).println("<!-- ========= END OF CLASS DATA ========= -->");
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printAllMembers() {
        ((PrintWriter)((Object)this)).println("<!-- ======== INNER CLASS SUMMARY ======== -->");
        ((PrintWriter)((Object)this)).println();
        this.innerSubWriter.printMembersSummary();
        this.innerSubWriter.printInheritedMembersSummary();
        ((PrintWriter)((Object)this)).println();
        ((PrintWriter)((Object)this)).println("<!-- =========== FIELD SUMMARY =========== -->");
        ((PrintWriter)((Object)this)).println();
        this.fieldSubWriter.printMembersSummary();
        this.fieldSubWriter.printInheritedMembersSummary();
        ((PrintWriter)((Object)this)).println();
        ((PrintWriter)((Object)this)).println("<!-- ======== CONSTRUCTOR SUMMARY ======== -->");
        ((PrintWriter)((Object)this)).println();
        this.constrSubWriter.printMembersSummary();
        ((PrintWriter)((Object)this)).println();
        ((PrintWriter)((Object)this)).println("<!-- ========== METHOD SUMMARY =========== -->");
        ((PrintWriter)((Object)this)).println();
        this.methodSubWriter.printMembersSummary();
        this.methodSubWriter.printInheritedMembersSummary();
        this.p();
        ((PrintWriter)((Object)this)).println();
        ((PrintWriter)((Object)this)).println("<!-- ============ FIELD DETAIL =========== -->");
        ((PrintWriter)((Object)this)).println();
        this.fieldSubWriter.printMembers();
        ((PrintWriter)((Object)this)).println();
        ((PrintWriter)((Object)this)).println("<!-- ========= CONSTRUCTOR DETAIL ======== -->");
        ((PrintWriter)((Object)this)).println();
        this.constrSubWriter.printMembers();
        ((PrintWriter)((Object)this)).println();
        ((PrintWriter)((Object)this)).println("<!-- ============ METHOD DETAIL ========== -->");
        ((PrintWriter)((Object)this)).println();
        this.methodSubWriter.printMembers();
    }

    protected void printClassDescription() {
        ClassDoc[] implIntfacs;
        ClassDoc superclass;
        boolean isInterface = this.classdoc.isInterface();
        this.dl();
        this.dt();
        ((PrintWriter)((Object)this)).print(String.valueOf(this.classdoc.modifiers()) + " ");
        if (!isInterface) {
            ((PrintWriter)((Object)this)).print("class ");
        }
        this.bold(this.classdoc.name());
        if (!isInterface && (superclass = this.classdoc.superclass()) != null) {
            this.dt();
            ((PrintWriter)((Object)this)).print("extends ");
            this.printClassLink(superclass);
        }
        if ((implIntfacs = this.classdoc.interfaces()) != null && implIntfacs.length > 0) {
            this.dt();
            ((PrintWriter)((Object)this)).print(isInterface ? "extends " : "implements ");
            this.printClassLink(implIntfacs[0]);
            int i = 1;
            while (i < implIntfacs.length) {
                ((PrintWriter)((Object)this)).print(", ");
                this.printClassLink(implIntfacs[i]);
                ++i;
            }
        }
        this.dlEnd();
    }

    protected void printDeprecated() {
        Tag[] deprs = this.classdoc.tags("deprecated");
        if (deprs.length > 0) {
            Tag[] commentTags = deprs[0].inlineTags();
            if (commentTags.length > 0) {
                this.boldText("doclet.Deprecated");
                this.space();
                this.printInlineDeprecatedComment(deprs[0]);
            }
            this.p();
        }
    }

    protected void printStep(int indent) {
        String spc = this.spaces(6 * indent - 4);
        ((PrintWriter)((Object)this)).print(spc);
        ((PrintWriter)((Object)this)).println("|");
        ((PrintWriter)((Object)this)).print(spc);
        ((PrintWriter)((Object)this)).print("+--");
    }

    protected int printTreeForClass(ClassDoc cd) {
        ClassDoc sup = cd.superclass();
        int indent = 0;
        if (sup != null) {
            indent = this.printTreeForClass(sup);
            this.printStep(indent);
        }
        if (cd.equals(this.classdoc)) {
            this.bold(cd.qualifiedName());
        } else {
            this.printQualifiedClassLink(cd);
        }
        ((PrintWriter)((Object)this)).println();
        return indent + 1;
    }

    protected void printSubClassInterfaceInfo() {
        List subclasses;
        if (this.classdoc.qualifiedName().equals("java.lang.Object") || this.classdoc.qualifiedName().equals("org.omg.CORBA.Object")) {
            return;
        }
        List list = subclasses = this.classdoc.isClass() ? this.classtree.subs(this.classdoc) : this.classtree.allSubs(this.classdoc);
        if (subclasses.size() > 0) {
            this.printInfoHeader();
            if (this.classdoc.isClass()) {
                this.boldText("doclet.Subclasses");
            } else {
                this.boldText("doclet.Subinterfaces");
            }
            this.printSubClassLinkInfo(subclasses);
        }
    }

    protected void printImplementingClasses() {
        if (this.classdoc.qualifiedName().equals("java.lang.Cloneable") || this.classdoc.qualifiedName().equals("java.io.Serializable")) {
            return;
        }
        List implcl = this.classtree.implementingclasses(this.classdoc);
        if (implcl.size() > 0) {
            this.printInfoHeader();
            this.boldText("doclet.Implementing_Classes");
            this.printSubClassLinkInfo(implcl);
        }
    }

    protected void printSuperImplementedInterfacesInfo() {
        Object[] intarr = Util.getAllInterfaces((ClassDoc)this.classdoc);
        Arrays.sort(intarr);
        if (intarr.length > 0) {
            this.printInfoHeader();
            this.boldText(this.classdoc.isClass() ? "doclet.All_Implemented_Interfaces" : "doclet.All_Superinterfaces");
            this.printSubClassLinkInfo(Arrays.asList(intarr));
        }
    }

    protected void printInfoHeader() {
        this.dl();
        this.dt();
    }

    protected void printSubClassLinkInfo(List list) {
        int i = 0;
        ((PrintWriter)((Object)this)).print(' ');
        this.dd();
        while (i < list.size() - 1) {
            this.printClassLink((ClassDoc)list.get(i));
            ((PrintWriter)((Object)this)).print(", ");
            ++i;
        }
        this.printClassLink((ClassDoc)list.get(i));
        this.ddEnd();
        this.dlEnd();
    }

    protected void navLinkTree() {
        this.navCellStart();
        if (this.nopackage) {
            this.printHyperLink(String.valueOf(this.relativepath) + "overview-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        } else {
            this.printHyperLink("package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        }
        this.navCellEnd();
    }

    protected void printSummaryDetailLinks() {
        this.tr();
        this.tdVAlignClass("top", "NavBarCell3");
        this.font("-2");
        ((PrintWriter)((Object)this)).print("  ");
        this.navSummaryLinks();
        this.fontEnd();
        this.tdEnd();
        this.tdVAlignClass("top", "NavBarCell3");
        this.font("-2");
        this.navDetailLinks();
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
    }

    protected void navSummaryLinks() {
        this.printText("doclet.Summary");
        ((PrintWriter)((Object)this)).print("&nbsp;");
        this.innerSubWriter.navSummaryLink();
        this.navGap();
        this.fieldSubWriter.navSummaryLink();
        this.navGap();
        this.constrSubWriter.navSummaryLink();
        this.navGap();
        this.methodSubWriter.navSummaryLink();
    }

    protected void navDetailLinks() {
        this.printText("doclet.Detail");
        ((PrintWriter)((Object)this)).print("&nbsp;");
        this.fieldSubWriter.navDetailLink();
        this.navGap();
        this.constrSubWriter.navDetailLink();
        this.navGap();
        this.methodSubWriter.navDetailLink();
    }

    protected void navGap() {
        this.space();
        ((PrintWriter)((Object)this)).print('|');
        this.space();
    }

    protected void printEnclosingClassInfo() {
        ClassDoc outerClass = this.classdoc.containingClass();
        if (outerClass != null) {
            this.printInfoHeader();
            this.boldText("doclet.Enclosing_Class");
            this.dd();
            this.printClassLink(outerClass);
            this.ddEnd();
            this.dlEnd();
        }
    }
}

